<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwindex="urn:WebWorks-Index-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwindex wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterTOCSplitFileType" />
 <xsl:param name="ParameterIndexSplitFileType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:include href="wwtransform:common/companyinfo/companyinfo_content.xsl" />
 <xsl:include href="wwtransform:html/css_properties.xsl" />
 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />
 <xsl:include href="wwtransform:uri/uri.xsl" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:html/css_properties.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:html/css_properties.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:uri/uri.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:uri/uri.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- Mapping Entry Sets -->
 <!--                    -->
 <xsl:variable name="GlobalMapEntrySetsPath" select="wwuri:AsFilePath('wwtransform:html/mapentrysets.xml')" />
 <xsl:variable name="GlobalMapEntrySets" select="wwexsldoc:LoadXMLWithoutResolver($GlobalMapEntrySetsPath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Generate Index? -->
   <!--                 -->
   <xsl:if test="wwprojext:GetFormatSetting('index-generate', 'true') = 'true'">
    <!-- Iterate input documents -->
    <!--                         -->
    <xsl:for-each select="$GlobalFiles[1]">
     <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

     <xsl:value-of select="wwprogress:Start(count($VarFilesByType))" />

     <xsl:for-each select="$VarFilesByType">
      <xsl:value-of select="wwprogress:Start(1)" />

      <xsl:variable name="VarFilesDocument" select="." />

      <!-- Load splits -->
      <!--             -->
      <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterSplitsType))[1]" />
      <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

      <xsl:for-each select="$VarSplits[1]">
       <!-- Split -->
       <!--       -->
       <xsl:variable name="VarSplit" select="key('wwsplits-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterIndexSplitFileType))[1]" />

       <!-- Transform -->
       <!--           -->
       <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarSplit/@path, '', $VarFilesDocument/@groupID, $VarFilesDocument/@documentID, $GlobalActionChecksum)" />
       <xsl:if test="not($VarUpToDate)">
        <xsl:variable name="VarResultAsXML">
         <!-- Load document -->
         <!--               -->
         <xsl:variable name="VarIndex" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesDocument/@path)" />

         <xsl:call-template name="Index">
          <xsl:with-param name="ParamSplits" select="$VarSplits" />
          <xsl:with-param name="ParamIndex" select="$VarIndex" />
          <xsl:with-param name="ParamSplit" select="$VarSplit" />
         </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
        <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarSplit/@path, wwprojext:GetFormatSetting('encoding', 'utf-8'), 'xhtml', '1.0', 'yes', 'no', 'no', '-//W3C//DTD XHTML 1.0 Transitional//EN', 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd')" />
       </xsl:if>

       <!-- Report Files -->
       <!--              -->
       <wwfiles:File path="{$VarSplit/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarSplit/@path)}" projectchecksum="" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
        <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$GlobalMapEntrySetsPath}" checksum="{wwfilesystem:GetChecksum($GlobalMapEntrySetsPath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$VarFilesSplits/@path}" checksum="{$VarFilesSplits/@checksum}" groupID="{$VarFilesSplits/@groupID}" documentID="{$VarFilesSplits/@documentID}" />
        <wwfiles:Depends path="{$VarFilesDocument/@path}" checksum="{$VarFilesDocument/@checksum}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" />
       </wwfiles:File>
      </xsl:for-each>

      <xsl:value-of select="wwprogress:End()" />
     </xsl:for-each>

     <xsl:value-of select="wwprogress:End()" />
    </xsl:for-each>
   </xsl:if>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Index">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamIndex" />
  <xsl:param name="ParamSplit" />

  <!-- Page Rule -->
  <!--           -->
  <xsl:variable name="VarPageRule" select="wwprojext:GetRule('Page', $ParamSplit/@stylename)" />

  <!-- CSS Path -->
  <!--          -->

  <!-- Split files -->
  <!--             -->
  <xsl:for-each select="$ParamSplits[1]">
   <!-- Generate Frameset? -->
   <!--                    -->
   <xsl:variable name="VarGenerateFrameset" select="wwprojext:GetFormatSetting('frameset-generate', 'false')" />

   <!-- TOC -->
   <!--     -->
   <xsl:variable name="VarTOCSplitFile" select="key('wwsplits-files-by-groupid-type', concat($ParamSplit/@groupID, ':', $ParameterTOCSplitFileType))[1]" />

   <!-- Index -->
   <!--       -->
   <xsl:variable name="VarIndexSplitFile" select="key('wwsplits-files-by-groupid-type', concat($ParamSplit/@groupID, ':', $ParameterIndexSplitFileType))[1]" />

   <!-- Previous -->
   <!--          -->
   <xsl:variable name="VarPossiblePreviousSplits" select="$ParamSplit/preceding-sibling::wwsplits:Split[1]" />
   <xsl:variable name="VarPreviousSplit" select="($VarPossiblePreviousSplits[count($VarPossiblePreviousSplits) = 1] | $VarTOCSplitFile[(count($VarPossiblePreviousSplits) = 0) and (count($ParamSplit | $VarTOCSplitFile) = 2)])" />

   <!-- Next -->
   <!--      -->
   <xsl:variable name="VarPossibleNextSplits" select="$ParamSplit/following-sibling::wwsplits:Split[1]" />
   <xsl:variable name="VarNextSplit" select="($VarPossibleNextSplits[count($VarPossibleNextSplits) = 1] | $VarIndexSplitFile[(count($VarPossibleNextSplits) = 0) and (count($ParamSplit | $VarIndexSplitFile) = 2)])" />

   <!-- Conditions -->
   <!--            -->
   <xsl:variable name="VarInitialConditionsAsXML">
    <!-- document-css -->
    <!--              -->
    <xsl:if test="string-length($VarPageRule/wwproject:Options/wwproject:Option[@Name = 'document-css']/@Value) &gt; 0">
     <wwpage:Condition name="document-css" />
    </xsl:if>

    <!-- navigation-top -->
    <!--                -->
    <xsl:variable name="VarNavigationTopGenerateOption" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'navigation-top-generate']/@Value" />
    <xsl:if test="($VarNavigationTopGenerateOption = 'true') or (string-length($VarNavigationTopGenerateOption) = 0)">
     <wwpage:Condition name="navigation-top" />
    </xsl:if>

    <!-- navigation-bottom -->
    <!--                   -->
    <xsl:variable name="VarNavigationBottomGenerateOption" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'navigation-bottom-generate']/@Value" />
    <xsl:if test="$VarNavigationBottomGenerateOption = 'true'">
     <wwpage:Condition name="navigation-bottom" />
    </xsl:if>

    <!-- Generate TOC? -->
    <!--               -->
    <xsl:if test="count($VarTOCSplitFile) = 1">
     <xsl:choose>
      <xsl:when test="(count($ParamSplit | $VarTOCSplitFile) = 1) or ($VarGenerateFrameset = 'false')">
       <!-- navigation-toc-current -->
       <!--                        -->
       <wwpage:Condition name="navigation-toc-current" />
      </xsl:when>

      <xsl:otherwise>
       <!-- navigation-toc-not-current -->
       <!--                        -->
       <xsl:if test="$VarGenerateFrameset = 'false'">
       <wwpage:Condition name="navigation-toc-not-current" />
       </xsl:if>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>

    <!-- navigation-previous-exists -->
    <!--                            -->
    <xsl:if test="((count($VarPreviousSplit) = 1) and ($VarGenerateFrameset = 'false')) or (($VarGenerateFrameset = 'true') and (count($VarPreviousSplit | $VarTOCSplitFile) = 2))">
     <wwpage:Condition name="navigation-previous-exists" />
    </xsl:if>

    <!-- navigation-previous-not-exists -->
    <!--                                -->
    <xsl:if test="((count($VarPreviousSplit) = 0) and ($VarGenerateFrameset = 'false')) or ((count($VarPreviousSplit) = 1) and ($VarGenerateFrameset = 'true') and (count($VarPreviousSplit | $VarTOCSplitFile) = 1))">
     <wwpage:Condition name="navigation-previous-not-exists" />
    </xsl:if>

    <!-- navigation-next-exists -->
    <!--                        -->
    <xsl:if test="count($VarNextSplit) = 1">
     <wwpage:Condition name="navigation-next-exists" />
    </xsl:if>

    <!-- navigation-next-not-exists -->
    <!--                            -->
    <xsl:if test="count($VarNextSplit) = 0">
     <wwpage:Condition name="navigation-next-not-exists" />
    </xsl:if>

    <!-- Generate Index? -->
    <!--                 -->
    <xsl:if test="count($VarIndexSplitFile) = 1">
     <xsl:choose>
      <xsl:when test="count($ParamSplit | $VarIndexSplitFile) = 1">
       <!-- navigation-index-current -->
       <!--                        -->
       <wwpage:Condition name="navigation-index-current" />
      </xsl:when>

      <xsl:otherwise>
       <!-- navigation-index-not-current -->
       <!--                        -->
       <wwpage:Condition name="navigation-index-not-current" />
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>

    <!-- Company Info -->
    <!--              -->
    <xsl:call-template name="CompanyInfo-Conditions">
     <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="VarInitialConditions" select="msxsl:node-set($VarInitialConditionsAsXML)" />

   <!-- Set header/footer conditions -->
   <!--                              -->
   <xsl:variable name="VarConditionsAsXML">
    <!-- Copy existing as is -->
    <!--                     -->
    <xsl:for-each select="$VarInitialConditions/*">
     <xsl:copy-of select="." />
    </xsl:for-each>

    <xsl:for-each select="$VarInitialConditions[1]">
     <!-- header-exists -->
     <!--               -->
     <xsl:variable name="VarHeaderExists" select="count(key('wwpage-conditions-by-name', 'navigation-top') | key('wwpage-conditions-by-name', 'breadcrumbs-top') | key('wwpage-conditions-by-name', 'company-info-top')) &gt; 0" />
     <xsl:if test="$VarHeaderExists">
      <wwpage:Condition name="header-exists" />
     </xsl:if>

     <!-- footer-exists -->
     <!--               -->
     <xsl:variable name="VarFooterExists" select="count(key('wwpage-conditions-by-name', 'navigation-bottom') | key('wwpage-conditions-by-name', 'breadcrumbs-bottom') | key('wwpage-conditions-by-name', 'company-info-bottom')) &gt; 0" />
     <xsl:if test="$VarFooterExists">
      <wwpage:Condition name="footer-exists" />
     </xsl:if>

     <!-- header-footer-exists -->
     <!--                      -->
     <xsl:choose>
      <xsl:when test="$VarHeaderExists or $VarFooterExists">
       <wwpage:Condition name="header-footer-exists" />
      </xsl:when>

      <xsl:otherwise>
       <wwpage:Condition name="header-footer-not-exists" />
      </xsl:otherwise>
     </xsl:choose>
    </xsl:for-each>
   </xsl:variable>
   <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

   <!-- Replacements -->
   <!--              -->
   <xsl:variable name="VarReplacementsAsXML">
    <!-- webworks-root -->
    <!--               -->
    <wwpage:Replacement name="webworks-root">
     <xsl:comment>
      <xsl:text>
</xsl:text>
      <xsl:text>        var  WebWorksRootPath = &quot;&quot;;
</xsl:text>
      <xsl:text>      // </xsl:text>
     </xsl:comment>
    </wwpage:Replacement>

    <!-- body-style -->
    <!--            -->
    <wwpage:Replacement name="body-style">
     <xsl:attribute name="value">
      <!-- CSS properties -->
      <!--                -->
      <xsl:variable name="VarCSSPropertiesAsXML">
       <xsl:call-template name="CSS-TranslateProjectProperties">
        <xsl:with-param name="ParamProperties" select="$VarPageRule/wwproject:Properties/wwproject:Property" />
        <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />

      <xsl:call-template name="CSS-InlineProperties">
       <xsl:with-param name="ParamProperties" select="$VarCSSProperties[string-length(@Value) &gt; 0]" />
      </xsl:call-template>
     </xsl:attribute>
    </wwpage:Replacement>

    <wwpage:Replacement name="title" value="{$ParamSplit/@title}" />
    <wwpage:Replacement name="navigation-toc-title" value="{$VarTOCSplitFile/@title}" />
    <wwpage:Replacement name="navigation-previous-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'Previous']/@value}" />
    <wwpage:Replacement name="navigation-next-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'Next']/@value}" />
    <wwpage:Replacement name="navigation-index-title" value="{$VarIndexSplitFile/@title}" />

    <wwpage:Replacement name="document-css">
     <xsl:attribute name="value">
      <xsl:call-template name="URI-ResolveProjectFileURI">
       <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
       <xsl:with-param name="ParamSplits" select="$ParamSplits" />
       <xsl:with-param name="ParamURI" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'document-css']/@Value" />
      </xsl:call-template>
     </xsl:attribute>
    </wwpage:Replacement>

    <wwpage:Replacement name="locale" value="{wwprojext:GetFormatSetting('locale', 'en')}" />
    <wwpage:Replacement name="content-type" value="{concat('text/html;charset=', wwprojext:GetFormatSetting('encoding', 'utf-8'))}" />

    <wwpage:Replacement name="navigation-top-style">
     <xsl:attribute name="value">
      <xsl:variable name="VarAlignmentProperty" select="$VarPageRule/wwproject:Properties/wwproject:Property[@Name = 'navigation-top-alignment']/@Value" />
      <xsl:choose>
       <xsl:when test="string-length($VarAlignmentProperty) &gt; 0">
        <xsl:value-of select="concat('text-align: ', $VarAlignmentProperty, ';')" />
       </xsl:when>

       <xsl:otherwise>
        <xsl:value-of select="'text-align: left;'" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:attribute>
    </wwpage:Replacement>

    <wwpage:Replacement name="navigation-bottom-style">
     <xsl:attribute name="value">
      <xsl:variable name="VarAlignmentProperty" select="$VarPageRule/wwproject:Properties/wwproject:Property[@Name = 'navigation-bottom-alignment']/@Value" />
      <xsl:choose>
       <xsl:when test="string-length($VarAlignmentProperty) &gt; 0">
        <xsl:value-of select="concat('text-align: ', $VarAlignmentProperty, ';')" />
       </xsl:when>

       <xsl:otherwise>
        <xsl:value-of select="'text-align: left;'" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:attribute>
    </wwpage:Replacement>

    <xsl:if test="count($VarTOCSplitFile) = 1">
     <wwpage:Replacement name="navigation-toc-link" value="{wwuri:GetRelativeTo($VarTOCSplitFile/@path, $ParamSplit/@path)}" />
    </xsl:if>
    <xsl:if test="count($VarPreviousSplit) = 1">
     <wwpage:Replacement name="navigation-previous-link" value="{wwuri:GetRelativeTo($VarPreviousSplit/@path, $ParamSplit/@path)}" />
    </xsl:if>
    <xsl:if test="count($VarNextSplit) = 1">
     <wwpage:Replacement name="navigation-next-link" value="{wwuri:GetRelativeTo($VarNextSplit/@path, $ParamSplit/@path)}" />
    </xsl:if>
    <xsl:if test="count($VarIndexSplitFile) = 1">
     <wwpage:Replacement name="navigation-index-link" value="{wwuri:GetRelativeTo($VarIndexSplitFile/@path, $ParamSplit/@path)}" />
    </xsl:if>

    <!-- Company Info -->
    <!--              -->
    <xsl:call-template name="CompanyInfo-Replacements">
     <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
     <xsl:with-param name="ParamPagePath" select="$ParamSplit/@path" />
     <xsl:with-param name="ParamSplits" select="$ParamSplits" />
    </xsl:call-template>

    <!-- Content -->
    <!--         -->
    <wwpage:Replacement name="content">
     <xsl:call-template name="Content-Content">
      <xsl:with-param name="ParamContent" select="$ParamIndex" />
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     </xsl:call-template>
    </wwpage:Replacement>
   </xsl:variable>
   <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

   <!-- Map common characters -->
   <!--                       -->
   <wwexsldoc:MappingContext>
    <xsl:copy-of select="$GlobalMapEntrySets/wwexsldoc:MapEntrySets/wwexsldoc:MapEntrySet[@name = 'common']/wwexsldoc:MapEntry" />

    <!-- Invoke page template -->
    <!--                      -->
    <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
     <xsl:with-param name="ParamOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetGroupName($ParamSplit/@groupID))" />
     <xsl:with-param name="ParamOutputPath" select="$ParamSplit/@path" />
     <xsl:with-param name="ParamConditions" select="$VarConditions" />
     <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
    </xsl:apply-templates>
   </wwexsldoc:MappingContext>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Content-Content">
  <xsl:param name="ParamContent" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamSplit" />

  <html:h2 class="WebWorks_Index_Title">
   <xsl:value-of select="$ParamSplit/@title" />
  </html:h2>

  <xsl:call-template name="Sections">
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
   <xsl:with-param name="ParamIndex" select="$ParamContent/wwindex:Index" />
  </xsl:call-template>
 </xsl:template>


 <xsl:template name="Sections">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamIndex" />

  <xsl:for-each select="$ParamIndex/wwindex:Section">
   <xsl:variable name="VarSection" select="." />

   <xsl:call-template name="Groups">
    <xsl:with-param name="ParamSplit" select="$ParamSplit" />
    <xsl:with-param name="ParamSection" select="$VarSection" />
   </xsl:call-template>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Groups">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamSection" />

  <xsl:for-each select="$ParamSection/wwindex:Group">
   <xsl:variable name="VarGroup" select="." />

   <html:div class="WebWorks_Index_Group">
    <xsl:value-of select="$VarGroup/@name" />
   </html:div>

   <xsl:call-template name="Entries">
    <xsl:with-param name="ParamSplit" select="$ParamSplit" />
    <xsl:with-param name="ParamParent" select="$VarGroup" />
    <xsl:with-param name="ParamLevel" select="1" />
   </xsl:call-template>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Entries">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParent" />
  <xsl:param name="ParamLevel" />

  <xsl:for-each select="$ParamParent/wwindex:Entry">
   <xsl:variable name="VarEntry" select="." />

   <xsl:variable name="VarSee" select="$VarEntry/wwindex:See[1]" />

   <html:div>
    <xsl:attribute name="class">
     <xsl:text>WebWorks_Index_Level</xsl:text>
     <xsl:value-of select="$ParamLevel" />
    </xsl:attribute>


    <xsl:choose>
     <xsl:when test="count($VarSee) = 1">
      <!-- See/See Also -->
      <!--              -->
      <html:a class="WebWorks_Index_Link">
       <xsl:attribute name="href">
        <xsl:text>#</xsl:text>
        <xsl:value-of select="$VarSee/@entryID" />
       </xsl:attribute>

       <xsl:call-template name="Content">
        <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
       </xsl:call-template>
      </html:a>
     </xsl:when>

     <xsl:otherwise>
      <!-- Regular entry -->
      <!--               -->
      <xsl:variable name="VarLinks" select="$VarEntry/wwindex:Link" />

      <xsl:choose>
       <xsl:when test="count($VarLinks) = 0">
        <!-- Emit entry without any links -->
        <!--                              -->
        <xsl:choose>
         <xsl:when test="string-length($VarEntry/@id) &gt; 0">
          <html:a name="{$VarEntry/@id}">
           <xsl:call-template name="Content">
            <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
           </xsl:call-template>
          </html:a>
         </xsl:when>

         <xsl:otherwise>
          <xsl:call-template name="Content">
           <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
          </xsl:call-template>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:when>

       <xsl:when test="(count($VarLinks) = 1) and (count($VarLinks[1]/wwdoc:Content[1]) = 0)">
        <!-- Wrap link directly around entry -->
        <!--                                 -->
        <xsl:variable name="VarLink" select="$VarLinks[1]" />
        <xsl:variable name="VarRelativeLinkPath" select="wwuri:GetRelativeTo($VarLink/@href, $ParamSplit/@path)" />

        <html:a class="WebWorks_Index_Link">
         <xsl:if test="string-length($VarEntry/@id) &gt; 0">
          <xsl:attribute name="name">
           <xsl:value-of select="$VarEntry/@id" />
          </xsl:attribute>
         </xsl:if>
         <xsl:attribute name="href">
          <xsl:value-of select="$VarRelativeLinkPath" />
          <xsl:if test="$VarLink/@first != 'true'">
           <xsl:text>#</xsl:text>
           <xsl:value-of select="$VarLink/@anchor" />
          </xsl:if>
         </xsl:attribute>

         <xsl:call-template name="Content">
          <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
         </xsl:call-template>
        </html:a>
       </xsl:when>

       <xsl:otherwise>
        <!-- Emit entry followed by links -->
        <!--                              -->
        <xsl:choose>
         <xsl:when test="string-length($VarEntry/@id) &gt; 0">
          <html:a name="{$VarEntry/@id}">
           <xsl:call-template name="Content">
            <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
           </xsl:call-template>
          </html:a>
         </xsl:when>

         <xsl:otherwise>
          <xsl:call-template name="Content">
           <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
          </xsl:call-template>
         </xsl:otherwise>
        </xsl:choose>

        <!-- Links -->
        <!--       -->
        <xsl:for-each select="$VarLinks">
         <xsl:variable name="VarLink" select="." />

         <!-- Space things out a bit -->
         <!--                        -->
         <xsl:if test="position() &gt; 1">
          <xsl:text>,</xsl:text>
         </xsl:if>
         <xsl:text> </xsl:text>

         <xsl:variable name="VarRelativeLinkPath" select="wwuri:GetRelativeTo($VarLink/@href, $ParamSplit/@path)" />

         <xsl:choose>
          <xsl:when test="count($VarLink/wwdoc:Content[1]) = 1">
           <!-- Link has explicit text to show -->
           <!--                                -->
           <xsl:variable name="VarLinkSee" select="$VarLink/wwdoc:See[1]" />
           <xsl:choose>
            <xsl:when test="count($VarLinkSee) = 1">
             <!-- See/See Also link redirect -->
             <!--                            -->
             <html:a class="WebWorks_Index_Link">
              <xsl:attribute name="href">
               <xsl:text>#</xsl:text>
               <xsl:value-of select="$VarLinkSee/@entryID" />
              </xsl:attribute>

              <xsl:call-template name="Content">
               <xsl:with-param name="ParamContent" select="$VarLink/wwdoc:Content[1]" />
              </xsl:call-template>
             </html:a>
            </xsl:when>

            <xsl:otherwise>
             <!-- Wrap link around content -->
             <!--                          -->
             <html:a class="WebWorks_Index_Link">
              <xsl:attribute name="href">
               <xsl:value-of select="$VarRelativeLinkPath" />
               <xsl:if test="$VarLink/@first != 'true'">
                <xsl:text>#</xsl:text>
                <xsl:value-of select="$VarLink/@anchor" />
               </xsl:if>
              </xsl:attribute>

              <xsl:call-template name="Content">
               <xsl:with-param name="ParamContent" select="$VarLink/wwdoc:Content[1]" />
              </xsl:call-template>
             </html:a>
            </xsl:otherwise>
           </xsl:choose>
          </xsl:when>

          <xsl:otherwise>
           <!-- Emit numbered entry -->
           <!--                     -->
           <html:a class="WebWorks_Index_Link">
            <xsl:attribute name="href">
             <xsl:value-of select="$VarRelativeLinkPath" />
             <xsl:if test="$VarLink/@first != 'true'">
              <xsl:text>#</xsl:text>
              <xsl:value-of select="$VarLink/@anchor" />
             </xsl:if>
            </xsl:attribute>

            <xsl:value-of select="position()" />
           </html:a>
          </xsl:otherwise>
         </xsl:choose>
        </xsl:for-each>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:otherwise>
    </xsl:choose>

   </html:div>

   <!-- Process children -->
   <!--                  -->
   <xsl:for-each select="$VarEntry/wwindex:Entry[1]">
    <xsl:call-template name="Entries">
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamParent" select="$VarEntry" />
     <xsl:with-param name="ParamLevel" select="$ParamLevel + 1" />
    </xsl:call-template>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Content">
  <xsl:param name="ParamContent" />

  <!-- Simple processing for now -->
  <!--                           -->
  <xsl:for-each select="$ParamContent/wwdoc:TextRun/wwdoc:Text">
   <xsl:value-of select="@value" />
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
